/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm.traceroute;

import ibm.nways.jdm.NMPlatformDBClient;
import ibm.nways.jdm.common.IPAddress;
import ibm.nways.jdm.snmp.SnmpAPI;
import ibm.nways.jdm.snmp.SnmpPDU;
import ibm.nways.jdm.snmp.SnmpPDUException;
import ibm.nways.jdm.snmp.SnmpSession;
import ibm.nways.jdm.snmp.SnmpSocketException;
import ibm.nways.jdm.snmp.SnmpUnknownHostException;
import ibm.nways.jdm.snmp.SnmpVarBind;
import ibm.nways.jdm.traceroute.ITraceRouteServer;
import ibm.nways.jdm.traceroute.IUtil;
import ibm.nways.jdm.traceroute.RouteTable;
import ibm.nways.jdm.traceroute.SnmpRouteTable;
import ibm.nways.jdm.traceroute.voyager.Factory;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ResourceBundle;
import netscape.security.PrivilegeManager;

public class Util
implements IUtil {
    private static final boolean debug = false;
    private static ResourceBundle strings = ResourceBundle.getBundle((class$ibm$nways$jdm$traceroute$TraceRouteResources != null ? class$ibm$nways$jdm$traceroute$TraceRouteResources : (class$ibm$nways$jdm$traceroute$TraceRouteResources = Util.class$("ibm.nways.jdm.traceroute.TraceRouteResources"))).getName());
    static /* synthetic */ Class class$ibm$nways$jdm$traceroute$TraceRouteResources;
    static /* synthetic */ Class class$ibm$nways$jdm$traceroute$TraceRouteServer;

    public static String padString(String string, int n) {
        int n2 = string.length();
        if (n2 >= n) {
            return string;
        }
        int n3 = n - n2;
        StringBuffer stringBuffer = new StringBuffer(n3);
        int n4 = 0;
        while (n4 < n3) {
            stringBuffer.append(" ");
            ++n4;
        }
        return String.valueOf(string) + stringBuffer;
    }

    public static String trimString(String string, int n) {
        int n2 = n < 3 ? n : string.length();
        if (n2 > n) {
            string = String.valueOf(string.substring(0, n - 3)) + strings.getString("Ellipsis");
        }
        return string;
    }

    public static String dnsLookup(IPAddress iPAddress) {
        try {
            InetAddress inetAddress = InetAddress.getByName(iPAddress.toString());
            return inetAddress.getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            return null;
        }
    }

    public String remoteDnsLookup(IPAddress iPAddress) {
        return Util.dnsLookup(iPAddress);
    }

    public static String dnsLookup(IPAddress iPAddress, String string) {
        if (string != null) {
            try {
                if (System.getProperty("java.vendor").indexOf("Netscape") >= 0) {
                    PrivilegeManager.enablePrivilege((String)"UniversalConnect");
                }
                ITraceRouteServer iTraceRouteServer = (ITraceRouteServer)Factory.create((class$ibm$nways$jdm$traceroute$TraceRouteServer != null ? class$ibm$nways$jdm$traceroute$TraceRouteServer : (class$ibm$nways$jdm$traceroute$TraceRouteServer = Util.class$("ibm.nways.jdm.traceroute.TraceRouteServer"))).getName(), string);
                return iTraceRouteServer.remoteDnsLookup(iPAddress);
            }
            catch (Exception exception) {
                return null;
            }
        }
        String string2 = Util.dnsLookup(iPAddress);
        return string2;
    }

    public static IPAddress dnsLookup(String string) {
        try {
            InetAddress inetAddress = InetAddress.getByName(string);
            return new IPAddress(inetAddress.getHostAddress());
        }
        catch (UnknownHostException unknownHostException) {
            return null;
        }
    }

    public IPAddress remoteDnsLookup(String string) {
        return Util.dnsLookup(string);
    }

    public static IPAddress dnsLookup(String string, String string2) {
        if (string2 == null) {
            return Util.dnsLookup(string);
        }
        try {
            if (System.getProperty("java.vendor").indexOf("Netscape") >= 0) {
                PrivilegeManager.enablePrivilege((String)"UniversalConnect");
            }
            ITraceRouteServer iTraceRouteServer = (ITraceRouteServer)Factory.create((class$ibm$nways$jdm$traceroute$TraceRouteServer != null ? class$ibm$nways$jdm$traceroute$TraceRouteServer : (class$ibm$nways$jdm$traceroute$TraceRouteServer = Util.class$("ibm.nways.jdm.traceroute.TraceRouteServer"))).getName(), string2);
            return iTraceRouteServer.remoteDnsLookup(string);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Object lookupMibVar(IPAddress iPAddress, String string, String string2) {
        Object[] objectArray = Util.lookupMibVars(iPAddress, string, new String[]{string2});
        return objectArray[0];
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Object[] lookupMibVars(IPAddress iPAddress, String string, String[] stringArray) {
        string = Util.getCommunityName(iPAddress, string);
        SnmpSession snmpSession = null;
        Object[] objectArray = new Object[stringArray.length];
        try {
            try {
                SnmpAPI.initialize((int)-1);
                snmpSession = SnmpSession.open((String)iPAddress.toString(), (String)string);
                SnmpPDU snmpPDU = snmpSession.makePDU();
                snmpPDU.operation = 0;
                int n = 0;
                while (n < stringArray.length) {
                    snmpPDU.addVarBind(stringArray[n]);
                    ++n;
                }
                SnmpPDU snmpPDU2 = snmpSession.send(snmpPDU);
                if (snmpPDU2.errorStatus == 0) {
                    int n2 = 0;
                    while (n2 < stringArray.length) {
                        SnmpVarBind snmpVarBind = snmpPDU2.varBindAt(n2);
                        Serializable serializable = snmpVarBind.getVar();
                        objectArray[n2] = serializable;
                        ++n2;
                    }
                }
            }
            catch (SnmpSocketException snmpSocketException) {
            }
            catch (SnmpUnknownHostException snmpUnknownHostException) {
            }
            catch (Exception exception) {
            }
            Object var6_14 = null;
            if (snmpSession == null) return objectArray;
        }
        catch (Throwable throwable) {
            Object var6_15 = null;
            if (snmpSession == null) throw throwable;
            snmpSession.close();
            throw throwable;
        }
        snmpSession.close();
        return objectArray;
    }

    public Object[] remoteLookupMibVars(IPAddress iPAddress, String string, String[] stringArray) {
        return Util.lookupMibVars(iPAddress, string, stringArray);
    }

    public static Object[] lookupMibVars(IPAddress iPAddress, String string, String[] stringArray, String string2) {
        if (string2 == null) {
            return Util.lookupMibVars(iPAddress, string, stringArray);
        }
        Object[] objectArray = new Object[stringArray.length];
        try {
            if (System.getProperty("java.vendor").indexOf("Netscape") >= 0) {
                PrivilegeManager.enablePrivilege((String)"UniversalConnect");
            }
            ITraceRouteServer iTraceRouteServer = (ITraceRouteServer)Factory.create((class$ibm$nways$jdm$traceroute$TraceRouteServer != null ? class$ibm$nways$jdm$traceroute$TraceRouteServer : (class$ibm$nways$jdm$traceroute$TraceRouteServer = Util.class$("ibm.nways.jdm.traceroute.TraceRouteServer"))).getName(), string2);
            objectArray = iTraceRouteServer.remoteLookupMibVars(iPAddress, string, stringArray);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return objectArray;
    }

    public static RouteTable getRouteTable(IPAddress iPAddress, String string) throws SnmpUnknownHostException, SnmpSocketException, SnmpPDUException, Exception {
        string = Util.getCommunityName(iPAddress, string);
        return new SnmpRouteTable(iPAddress, string);
    }

    public RouteTable remoteGetRouteTable(IPAddress iPAddress, String string) throws SnmpUnknownHostException, SnmpSocketException, SnmpPDUException, Exception {
        return Util.getRouteTable(iPAddress, string);
    }

    public static RouteTable getRouteTable(IPAddress iPAddress, String string, String string2) throws SnmpUnknownHostException, SnmpSocketException, SnmpPDUException, Exception {
        if (string2 == null) {
            return Util.getRouteTable(iPAddress, string);
        }
        if (System.getProperty("java.vendor").indexOf("Netscape") >= 0) {
            PrivilegeManager.enablePrivilege((String)"UniversalConnect");
        }
        ITraceRouteServer iTraceRouteServer = (ITraceRouteServer)Factory.create((class$ibm$nways$jdm$traceroute$TraceRouteServer != null ? class$ibm$nways$jdm$traceroute$TraceRouteServer : (class$ibm$nways$jdm$traceroute$TraceRouteServer = Util.class$("ibm.nways.jdm.traceroute.TraceRouteServer"))).getName(), string2);
        return iTraceRouteServer.remoteGetRouteTable(iPAddress, string);
    }

    public static String getCommunityName(IPAddress iPAddress, String string) {
        String string2 = NMPlatformDBClient.getCommunityName(iPAddress.toString());
        if (string2 == null || string2.equals("unknown")) {
            return string;
        }
        return string2;
    }

    public static String getWriteCommunityName(IPAddress iPAddress, String string) {
        String string2 = NMPlatformDBClient.getWriteCommunityName(iPAddress.toString());
        if (string2 == null || string2.equals("unknown")) {
            return string;
        }
        return string2;
    }

    private static void debugDump(IPAddress iPAddress, String string, String[] stringArray) {
        if (iPAddress == null) {
            System.err.println("     SNMP Host: null");
        } else {
            System.err.println("     SNMP Host: " + iPAddress.toString());
        }
        if (string == null) {
            System.err.println("Community Name: null");
        } else {
            System.err.println("Community Name: " + string);
        }
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n] == null) {
                System.err.println("OID[" + n + "]: null");
            } else {
                System.err.println("OID[" + n + "]: " + stringArray[n]);
            }
            ++n;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

